<?php
session_start();

// Redirect to login if not logged in
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

// Database connection
$host = 'localhost';
$dbname = 'user_profiles';
$username = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Handle form submission for the second form
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $profile_link = $_SESSION['profile_link'];

    // Prepare the SQL query
    $fields = [
        'battery', 'keys_intelligent_key', 'remote', 'horn', 'cigar_lighter', 'cover_power_outlet', 'washer_nipples', 
        'original_carpets', 'wiper_blades', 'wiper_arms', 'model_make_badges', 'lights_head', 'lights_parking', 'lights_signal', 
        'lights_reverse', 'number_plates', 'fogs', 'fender', 'hood', 'brake_high_mounted_stop_light', 'fuel_tank_cap', 
        'wheels_alloy', 'wheels_steel', 'wheels_std', 'full_wheel_covers', 'wheel_center_caps', 'inside_mirror', 'mud_flaps', 
        'side_mirrors_power', 'side_mirrors_manual', 'side_mirrors_retractable', 'body_moldings', 'radio', 'cassette', 'cd_player', 
        'cd_changer', 'usb', 'mp3', 'dicky_board', 'carpet', 'dvd', 'remote_control', 'hydraulic_jack', 'mechanical', 'screen', 
        'monitor', 'spanners', 'pliers', 'speaker', 'spare_wheel', 'ash_tray', 'door_lock_knobs', 'handle', 'wheel', 'fuse_box', 
        'cover', 'mats', 'sun_visor', 'vanity_mirrors', 'reverse_sensors', 'front_image', 'back_image', 'left_image', 'right_image', 
        'top_image', 'bottom_image'
    ];

    $updates = [];
    foreach ($fields as $field) {
        $updates[] = "$field = :$field";
    }

    $sql = "UPDATE users SET " . implode(', ', $updates) . " WHERE profile_link = :profile_link";
    $stmt = $pdo->prepare($sql);

    // Handle file uploads for images
    $image_fields = ['front_image', 'back_image', 'left_image', 'right_image', 'top_image', 'bottom_image'];
    foreach ($image_fields as $image_field) {
        if (isset($_FILES[$image_field]) && $_FILES[$image_field]['error'] == UPLOAD_ERR_OK) {
            $image_tmp_name = $_FILES[$image_field]['tmp_name'];
            $image_name = uniqid($image_field . '_') . '.' . pathinfo($_FILES[$image_field]['name'], PATHINFO_EXTENSION);

            // Validate image file type (allow only image files)
            $valid_image_types = ['image/jpeg', 'image/png', 'image/gif'];
            if (!in_array($_FILES[$image_field]['type'], $valid_image_types)) {
                die("Error: Invalid file type for $image_field. Only JPG, PNG, or GIF files are allowed.");
            }

            // Validate image size (max 2MB)
            if ($_FILES[$image_field]['size'] > 2 * 1024 * 1024) {
                die("Error: $image_field file size exceeds the limit of 2MB.");
            }

            $upload_dir = 'uploads/images/';
            
            // Ensure the upload directory exists
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0755, true);
            }

            $target_file = $upload_dir . $image_name;
            move_uploaded_file($image_tmp_name, $target_file);

            // Bind the image file path to the SQL statement
            $stmt->bindParam(":$image_field", $target_file);
        }
    }

    // Bind other form fields to the SQL statement
    $stmt->bindParam(':profile_link', $profile_link);
    foreach ($fields as $field) {
        if (!in_array($field, $image_fields)) {
            if (isset($_POST[$field])) {
                $stmt->bindParam(":$field", $_POST[$field]);
            } else {
                // Handle missing fields if necessary (e.g., set as NULL)
                $stmt->bindParam(":$field", null, PDO::PARAM_NULL);
            }
        }
    }

    // Execute the query
    try {
        $stmt->execute();
        echo "User profile updated successfully! Profile link: <a href='profile.php?link=$profile_link'>View Profile</a>";
    } catch (PDOException $e) {
        die("Error: " . $e->getMessage());
    }
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="./assets/css/tailwind.output.css">
    <script src="https://cdn.jsdelivr.net/gh/alpinejs/alpine@v2.x.x/dist/alpine.min.js" defer></script>
</head>
<body class="bg-gray-50 dark:bg-gray-900">
    <div class="flex h-screen">
        <!-- Sidebar -->
        <aside class="z-20 hidden w-64 overflow-y-auto bg-white dark:bg-gray-800 md:block flex-shrink-0">
            <div class="py-4 text-gray-500 dark:text-gray-400">
                <a class="ml-6 text-lg font-bold text-gray-800 dark:text-gray-200" href="#">
                    Admin Dashboard
                </a>
                <ul class="mt-6">
                    <li class="relative px-6 py-3">
                        <span class="absolute inset-y-0 left-0 w-1 bg-purple-600 rounded-tr-lg rounded-br-lg" aria-hidden="true"></span>
                        <a class="inline-flex items-center w-full text-sm font-semibold text-gray-800 transition-colors duration-150 hover:text-gray-800 dark:hover:text-gray-200 dark:text-gray-100" href="#">
                            <svg class="w-5 h-5" aria-hidden="true" fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor">
                                <path d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                            </svg>
                            <span class="ml-4">Dashboard</span>
                        </a>
                    </li>
                </ul>
            </div>
        </aside>

    <div class="flex flex-col flex-1 w-full">
        <h1 class="text-2xl font-semibold p-4">Second Form</h1>
        <form method="POST" action="" enctype="multipart/form-data" class="p-4">
            <table class="table-auto w-full">
                <?php
                $fields = [
                    'Battery', 'Keys – Intelligent key', 'Remote', 'Horn', 'Cigar lighter', 'Cover for power outlet', 'Washer nipples', 
                    'Original carpets (make)', 'Wiper blades', 'Wiper arms', 'Model and make badges', 'Lights: Head', 'Parking', 
                    'Signal', 'Reverse', 'Number plates', 'Fogs', 'Fender', 'Hood', 'Brake & High mounted stop light', 'Fuel tank cap', 
                    'Wheels: Alloy', 'Steel', 'STD', 'Full wheel covers', 'Wheel center caps', 'Inside Mirror', 'Mud flaps', 
                    'Side Mirrors – Power', 'Manual', 'Retractable', 'Body moldings', 'Radio', 'Cassette', 'CD player', 'CD Changer', 
                    'USB', 'Mp3', 'Dickey board', 'Carpet', 'DVD', 'Remote', 'Hydraulic Jack', 'Mechanical', 'Screen', 'Monitor', 
                    'Spanners', 'Pliers', 'Speaker', 'Spare Wheel', 'Ash tray', 'Door lock knobs', 'Handle', 'Wheel', 'Fuse box', 
                    'Cover', 'Mats', 'Sun visor', 'Vanity Mirrors', 'Reverse Sensors'
                ];

                foreach ($fields as $field) {
                    $field_name = strtolower(str_replace([' ', '–', '&'], ['_', '', ''], $field));
                    echo "<tr>";
                    echo "<td><label for='$field_name'>$field:</label></td>";
                    echo "<td><select name='$field_name' id='$field_name'>";
                    echo "<option value='Yes'>Yes</option>";
                    echo "<option value='No'>No</option>";
                    echo "</select></td>";
                    echo "</tr>";
                }
                ?>

                <!-- Image Upload Fields -->
                <?php
                $image_fields = ['front_image', 'back_image', 'left_image', 'right_image', 'top_image', 'bottom_image'];
                foreach ($image_fields as $image_field) {
                    echo "<tr>";
                    echo "<td><label for='$image_field'>". ucfirst(str_replace('_', ' ', $image_field)) . ":</label></td>";
                    echo "<td><input type='file' name='$image_field' id='$image_field' required></td>";
                    echo "</tr>";
                }
                ?>
            </table>
            <button type="submit" class="mt-4 bg-blue-500 text-white py-2 px-4 rounded">Submit</button>
        </form>
    </div>
    </div>
</body>
</html>
